#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Spherical CandiesMod01.fsh  by   technochroma  
//https://www.shadertoy.com/view/cssyD2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Spherical by technochroma
// original "loonie" code by Crystalize, "gnarl" by jarble https://www.shadertoy.com/view/3syyDD

//loonie begin

vec2 loonie(vec2 z) {
    float r = dot(z,z);
    return r > 1. ? z : z * log(exp(1./r - 1.));
}
#define AA 7
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = 0.2 * (fragCoord.xy - 0.25*iResolution.xy) / -iResolution.y;
    
    float t = iTime;
    
    uv *= 2.7;
    uv = loonie(uv);
    uv -= vec2(t,t * 0.2 / 30.);
    uv *= 1.5;
    
//    float grid = mod(sin(uv.x)+cos(uv.y),2.);
    
     vec3 col;
     
// gnarls begin

    for(int c=0;c<5;c++){
//	    vec2 uv = (fragCoord*20.0-iResolution.xy)/iResolution.y;
        t = iTime;
        for(int i=1;i<4;i++)
        {
            uv /= 1.00;
            uv += cosh(col.yx);
        	uv += float(i) + (sin(uv.x)*atan(uv.y)+sin(uv.y)*sin(iTime)+cos(iTime)*sin(uv.x)); 
        }
    col[c] = (cos(uv.x+uv.y+iTime));
	}
    
    fragColor = vec4(col,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

// loonie end  
    
    // small bit of anti-aliasing (fixed 2)
    // drop this in voidmain after fragcolor
    
	vec2 of = vec2(0.3);

    #ifdef AA
	const float aa = float(AA);
    #else
    const float aa = 1.0;

	
	for(float i = 0.0; i < aa - 1.0; i++) {

		// super-sample around the center of the pixel.
		vec2 p = (-iResolution.xy + 2.0*(uv + of))/iResolution.y;
        col += render(p);
		of *= r(3.14159/8.0);
        
        	}
	
	col /= aa;
	
	col += 0.2*clamp(col, 0.0, 0.5);
	col = pow(col, vec3(1.0/2.2));
        
    #endif 
    

    
         


///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(1.0 - gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

